//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Strings
//:
//: Strings have a lot of features.
//:
//: Execute the code below.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


let congratulationsMessage: String = "Congratulations. You passed!"
let commiserationsMessage: String = "Sorry. You failed this time."
let eligableForRemarkMessage: String = "You are eligable to have your mark reconsidered. Contact the exam board."
let examScore: Int = 50
let studentPassed: Bool
if examScore > 50 {
    studentPassed = true
} else {
    studentPassed = false
}
if studentPassed {
    print(congratulationsMessage)
} else {
    print(commiserationsMessage)
}
if examScore == 50 {
    print(eligableForRemarkMessage)
}


//:
//: -------------------
//:
//: ## String Concatenation
//:
//: String values can be joined together using the addition operator (`+`).
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


let title: String = "Mr"
let firstName: String = "John"
let surname: String = "Appleseed"
let concatonatedString = "Title: " + title + " First name: " + firstName + " Surname: " + surname
print(concatonatedString)


//:
//: -------------------
//:
//: ## String Interpolation
//:
//: String interpolation is used to embed values within strings written in our sourcecode. We can these values "string literals" and they begin and end with double quotes (`""`).
//:
//: To embed values in string literals encapsulate them in brackets following the escape character (`\(value)`).
//:
//: -------------------
//:


let embeddedValues = "Title: \(title) First name: \(firstName) Surname: \(surname)"
print(embeddedValues)


//:
//: -------------------
//:
//: ## New Line Character (`\n`)
//:
//: The backslash character (`\`) is reserved and is code for the `String` to perform special actions.
//:
//: We can use the backslash followed by an n (`\n`) to move our text onto a new line. For example:
//:
//: -------------------
//:


let embeddedValuesOnNewLines = "Title: \(title) \nFirst name: \(firstName) \nSurname: \(surname)"
print(embeddedValuesOnNewLines)


//:
//: -------------------
//:
//: ## Multiline Strings
//: A `String` can be written on multiple lines using three double quotation marks *(`"""`)*.
//:
//: Using this approach would eliminate the need to insert new line characters (`\n`) or "line breaks" into our code.
//:
//: -------------------
//:


let swift = """
                  @@@
      @@          @@@@
    @@  @@@         @@@@@
    @@@@@@@@@       @@@@@
      @@@@@@@@@@    @@@@@@
        @@@@@@@@@@  @@@@@@
          @@@@@@@@@@@@@@@@@
@           @@@@@@@@@@@@@@@
@@@@@@        @@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@
    @@@@@@@@@@@@@@@@@@@@@@@@
        @@@@@@@@@@@@@     @
"""
print(swift)


//:
//: -------------------
//:
//:
//: The closing quotation marks must align with each line of text. Otherwise, it'll be considered an indentation.
//:
//: For example:
//:
//: -------------------
//:

let indentedSwift = """
                      @@@
          @@          @@@@
        @@  @@@         @@@@@
        @@@@@@@@@       @@@@@
          @@@@@@@@@@    @@@@@@
            @@@@@@@@@@  @@@@@@
              @@@@@@@@@@@@@@@@@
    @           @@@@@@@@@@@@@@@
    @@@@@@        @@@@@@@@@@@@@
      @@@@@@@@@@@@@@@@@@@@@@@@@@
        @@@@@@@@@@@@@@@@@@@@@@@@
            @@@@@@@@@@@@@     @
"""
print(indentedSwift)


//:
//: -------------------
//:
//: ## Special Characters in a String
//:
//: Some characters are used for special actions within a `String`.
//:
//:  * Backslash (`\`) is the "escape character" and what follows is code to inform the `String` of special operations, such as moving onto a new line.
//:  * Double quotes (`"`) are used to open and close a `String` hard-coded within our source code.
//:
//: -------------------
//:


let twoLines = "My new string\nis on two lines"
print(twoLines)


//:
//: -------------------
//:
//: If we want to include these special characters we "escape the characters" using the escape character (`\`). For example:
//:
//: -------------------
//:


let includingQuotes = "\"Hello\" is \"Hola\" in spanish"
print(includingQuotes) // \" is used to print double quotes


//:
//: -------------------
//:
//: ## Unicode
//:
//: "Unicode" is a character set used all over the world to represent text on a computer.
//:
//: To insert Unicode characters (instead of typing text directly) we insert the "Unicode scalar" into a `String` encapsulating the unicode number within a u and curly braces (`u{}`).
//:
//: For example:
//:
//: -------------------
//:


let dollarSign = "\u{24}"        // $,  Unicode scalar U+0024
let blackHeart = "\u{2665}"      // ♥,  Unicode scalar U+2665
let sparklingHeart = "\u{1F496}" // 💖, Unicode scalar U+1F496
print(dollarSign + "\n" + blackHeart + "\n" + sparklingHeart)

